/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.utilities;

public final class MathUtils {
    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp01(float value) {
        return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
    }

    public static double clamp01(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    public static float lerp(float a, float b, float time) {
        return a + (b - a) * MathUtils.clamp01(time);
    }

    public static double lerp(double a, double b, double time) {
        return a + (b - a) * MathUtils.clamp01(time);
    }

    public static float damp(float source, float destination, float smoothing, float dt) {
        return MathUtils.lerp(source, destination, 1.0f - (float)Math.pow(smoothing * smoothing, dt));
    }

    public static double damp(double source, double destination, double smoothing, double dt) {
        return MathUtils.lerp(source, destination, 1.0 - Math.pow(smoothing * smoothing, dt));
    }

    public static double stepTowards(double current, double target, double step) {
        if (current < target) {
            return Math.min(current + step, target);
        }
        if (current > target) {
            return Math.max(current - step, target);
        }
        return current;
    }
}

